#pragma once

#include "gatt_value_format.h"

#include <vector>

namespace quasar {

    class GattValueReader {
    public:
        enum class ResultCode {
            OK = 0,
            ALL_READ,
            INVALID_OFFSET
        };

        struct Result {
            ResultCode code;
            std::vector<uint8_t> data;
            Result(ResultCode /*code*/, std::vector<uint8_t> /*data*/);
        };

        GattValueReader(
            const std::vector<uint8_t>& value,
            ble_configuration::QuasarGattProtocol protocol = ble_configuration::QuasarGattProtocol::CHUNKED);

        Result read(uint16_t mtu, uint16_t offset);

        bool isFinished() const;

    private:
        std::vector<uint8_t> data_;
        size_t chunkOffset_{0};
    };

} // namespace quasar
