#pragma once

#include "gatt_value_format.h"
#include "quasar_gatt_characteristic.h"

#include <functional>
#include <memory>
#include <vector>

namespace quasar {

    class QuasarGattCharacteristic;

    class GattValueWriter {
    public:
        enum class ResultCode {
            OK = 0,
            ALREADY_FULL,
            HEADER_ERROR,
            TOO_LARGE_DATA,
            ALREADY_MISTAKEN
        };

        explicit GattValueWriter(std::weak_ptr<QuasarGattCharacteristic> ownerWeak);

        ResultCode write(const std::vector<uint8_t>& value);

        bool isFinished() const;

    private:
        ble_configuration::QuasarGattMessageHeader header_;
        std::vector<uint8_t> data_;
        std::weak_ptr<QuasarGattCharacteristic> ownerWeak_;
        bool isAlreadyFull_{false};
        bool isError_{false};
    };

} // namespace quasar
