#pragma once

#include "gatt_value_format.h"
#include "gatt_value_reader.h"
#include "gatt_value_writer.h"

#include <yandex_io/libs/bluetooth/gatt/i_gatt_characteristics.h>

#include <functional>
#include <map>
#include <memory>
#include <mutex>
#include <set>
#include <string>

namespace quasar {

    class GattValueWriter;

    class QuasarGattCharacteristic
        : public IGattCharacteristic,
          public std::enable_shared_from_this<QuasarGattCharacteristic> {
    public:
        using OnWriteSessionDone = std::function<void(std::vector<uint8_t>)>;

        QuasarGattCharacteristic(
            std::string name,
            std::string uuid,
            std::set<gatt_permission::GattPermission> permissions,
            ble_configuration::QuasarGattProtocol protocol = ble_configuration::QuasarGattProtocol::CHUNKED);

        void setWriteCallback(OnWriteSessionDone onWriteSessionDone);

        void setValue(std::vector<uint8_t> value);

        std::vector<uint8_t> readValueImpl(const IGattCharacteristic::Mac& mac, uint16_t mtu, uint16_t offset) override;

        void writeValueImpl(const IGattCharacteristic::Mac& mac, const std::vector<uint8_t>& value) override;
        void dropWriteSession(const IGattCharacteristic::Mac& mac);

        void onWriteSessionDone(std::vector<uint8_t> value);
        void dropReadSession(const IGattCharacteristic::Mac& mac);

        std::vector<uint8_t> getValue() const override;

    private:
        const ble_configuration::QuasarGattProtocol protocol_;

        std::mutex mutex_;
        OnWriteSessionDone onWriteSessionDone_;
        std::map<IGattCharacteristic::Mac, std::shared_ptr<GattValueReader>> readSessions_;
        std::map<IGattCharacteristic::Mac, std::shared_ptr<GattValueWriter>> writeSessions_;
        std::vector<uint8_t> value_;
    };

} // namespace quasar
