#pragma once

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/private/device_context.h>

#include <memory>
#include <mutex>
#include <string>
#include <cstdint>
#include <vector>

namespace quasar {

    class BrainService: public QuasarService {
    public:
        BrainService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~BrainService();

        std::string getServiceName() const override {
            return "braind";
        }

        void start() override;

    private:
        void handleQuasarMessage(const quasar::proto::QuasarMessage& quasarMessage);
        void broadcastSDKState();

        std::shared_ptr<YandexIO::IDevice> device_;
        std::mutex mutex_;

        quasar::proto::ConfigurationState configurationState_{quasar::proto::ConfigurationState::UNKNOWN_STATE};

        quasar::proto::AliceState aliceState_;

        using AppState = quasar::proto::AppState;
        AppState appState_;

        using IotState = quasar::proto::IotState;
        IotState iotState_;

        bool isAlarmPlaying_ = false;
        bool isTimerPlaying_ = false;
        uint32_t setAlarmsTimersCount_ = 0;

        struct TimerState {
            std::string id;
            std::uint64_t startTs;
            std::uint64_t endTs;
        };
        std::vector<TimerState> timers_;
        std::string icalendar_state_;

        bool isReminderPlaying_{false};

        bool isDoNotDisturbMode_{false};

        proto::IOEvent_SDKState_NotificationState notificationState_{proto::IOEvent_SDKState_NotificationState_NONE};

        quasar::proto::UpdateState updateState_;

        quasar::proto::WifiStatus wifiStatus_;

        quasar::proto::WifiList wifiList_;

        quasar::proto::CalldSessionState calldState_;

        quasar::proto::MultiroomState multiroomState_;

        quasar::proto::AllStartupSettings allStartupSettings_;

        std::unique_ptr<YandexIO::DeviceContext> deviceContext_;

        std::optional<bool> clockSynchronized_;

        std::shared_ptr<ipc::IConnector> alicedConnector_;
        std::shared_ptr<ipc::IConnector> alarmdConnector_;
        std::shared_ptr<ipc::IConnector> firstrundConnector_;
        std::shared_ptr<ipc::IConnector> updatesdConnector_;
        std::shared_ptr<ipc::IConnector> wifidConnector_;
        std::shared_ptr<ipc::IConnector> notificationdConnector_;
        std::shared_ptr<ipc::IConnector> calldConnector_;
        std::shared_ptr<ipc::IConnector> dndConnector_;
        std::shared_ptr<ipc::IConnector> ntpdConnector_;
        std::shared_ptr<ipc::IConnector> iotConnector_;
        std::shared_ptr<ipc::IConnector> multiroomConnector_;
    };

} /* namespace quasar */
