#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/periodic_executor.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/private/device_context.h>

#include <mutex>
#include <string>

namespace quasar {

    class BrickEndpoint {
    public:
        explicit BrickEndpoint(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~BrickEndpoint();

        int port() const;

        static const std::string SERVICE_NAME;

    private:
        void processQuasarMessage(const ipc::SharedMessage& message);

        void updateStatus(quasar::proto::BrickStatus newBrickStatus, const std::string& newBrickUrl, bool newSubscriptionMode);

        bool isBrickRequired() const;

        void checkBrickStatus();

        void saveSubscriptionMode() const;

        void loadSubscriptionMode();

        quasar::proto::BrickInfo createBrickInfo() const;

        static std::string brickStatusToString(quasar::proto::BrickStatus newBrickStatus);

        static int64_t getSteadyNowTimestampSec();

        static int64_t getSystemNowTimestampSec();

        std::shared_ptr<YandexIO::IDevice> device_;

        std::unique_ptr<PeriodicExecutor> brickExecutor_;

        std::mutex brickMutex_;
        quasar::proto::BrickStatus brickStatus_ = proto::BrickStatus::UNKNOWN_BRICK_STATUS;
        bool subscriptionMode_;
        bool useSteadyClock_;
        bool backendUpdateReceived_ = false;
        std::string subscriptionModeFilename_;
        int64_t lastUpdateTimeSec_ = 0;
        int64_t ttlSec_ = 0;
        std::string brickStatusUrl_;

        std::shared_ptr<ipc::IServer> server_;
        std::shared_ptr<ipc::IConnector> syncdConnector_;

        std::chrono::milliseconds firstBrickCheckDelay_;
        std::chrono::milliseconds regularBrickCheckDelay_;

        YandexIO::DeviceContext deviceContext_;

    public:
        std::function<void(const proto::QuasarMessage&)> onQuasarMessageReceivedCallback; // Testing purposes only!
    };

} // namespace quasar
