#include "brick_service.h"

using namespace quasar;

BrickService::BrickService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
{
}

std::string BrickService::getServiceName() const {
    return BrickEndpoint::SERVICE_NAME;
}

void BrickService::start()
{
    brickEndpoint_ = std::make_unique<BrickEndpoint>(device_, ipcFactory_);
}
