#pragma once

#include "brick_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class BrickService: public QuasarService {
    public:
        explicit BrickService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);

        std::string getServiceName() const override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<BrickEndpoint> brickEndpoint_;
    };

} // namespace quasar
