#pragma once

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/json_utils/json_utils.h>

#include <mutex>

namespace quasar {

    class BugReportEndpoint {
    public:
        explicit BugReportEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);
        ~BugReportEndpoint();

        static const std::string SERVICE_NAME;

    private:
        void handleQuasarMessage(const proto::QuasarMessage& message, ipc::IServer::IClientConnection& connection);

        void handleQuasarMessage(const proto::QuasarMessage& message);

        void doBugReport(const std::string& bugReportId);

        Json::Value getFilteredCustomCommands(const std::set<std::string>& allowedCustomCommands);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IServer> server_;
        std::shared_ptr<ipc::IConnector> pushdConnector_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;

        Lifetime lifetime_;
        Json::Value customCommandLogsConfig_;
        std::mutex customCommandLogsMutex_;
    };

} // namespace quasar
