#include "bug_report_service.h"

using namespace quasar;

BugReportService::BugReportService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IUserConfigProvider> userConfigProvider)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , userConfigProvider_(std::move(userConfigProvider))
{
}

std::string BugReportService::getServiceName() const {
    return BugReportEndpoint::SERVICE_NAME;
}

void BugReportService::start() {
    endpointPtr_ = std::make_unique<BugReportEndpoint>(device_, ipcFactory_, userConfigProvider_);
}
