#pragma once

#include "bug_report_endpoint.h"

#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {

    class BugReportService: public QuasarService {
    public:
        explicit BugReportService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IUserConfigProvider> userConfigProvider);

        std::string getServiceName() const override;

    private:
        void start() override;

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        std::shared_ptr<BugReportEndpoint> endpointPtr_;
    };

} // namespace quasar
