#pragma once

#include <yandex_io/callkit/session/session.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {

    class CallConnector: public messenger::Session {
    public:
        CallConnector(std::shared_ptr<ipc::IIpcFactory> ipcFactory);

        ~CallConnector();

    public:
        // Session state

        Session::State getState() override;

    public:
        // Call control

        void startCall(const std::string& userGuid, const std::string& callPayload) override;

        void startCallToOwnDevice(const std::string& deviceId, const std::string& callPayload) override;

        void declineIncomingCall() override;

        void acceptIncomingCall() override;

        void hangupCall() override;

        void sendHeartbeat() override;

        void setAllowUsualCalls(bool allowUsualCalls) override;

    private:
        std::shared_ptr<ipc::IConnector> toCalld_;
    };

} // namespace quasar
