#pragma once

#include <yandex_io/callkit/session/session.h>
#include <yandex_io/callkit/session/session_provider.h>
#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/signals/signal.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/directive_observer.h>
#include <yandex_io/sdk/private/device_context.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <optional>

namespace YandexIO {
    class Device;
} // namespace YandexIO

namespace quasar {

    class CallEndpoint: public YandexIO::SDKStateObserver {
    public:
        CallEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            const std::string& passportUid,
            const std::string& authToken,
            bool allowUsualCallsInitially,
            const std::vector<std::string>& autoAcceptUsers,
            const std::vector<std::string>& xivaSubscriptions,
            std::shared_ptr<YandexIO::SDKInterface> sdk);

        ~CallEndpoint();

    public:
        void setAllowUsualCalls(bool allowUsualCalls);
        ipc::SharedMessage getStatusMessage();
        ipc::SharedMessage processQuasarMessage(const ipc::Message& message);

        using IStatusChangedSignal = ISignal<const ipc::SharedMessage&>;
        IStatusChangedSignal& statusChangedSignal();

    private:
        void onSDKState(const YandexIO::SDKState& state) override;

        void handleAutoAccept(const messenger::Session::State& state, const std::vector<std::string>& users);

        void handleCallState(const messenger::Session::State& state);

        void handleTokenExpired(const messenger::Session::State& state);

    private:
        void stopMusicAndDialog();

        void resumeMusic();

        void playSound(const std::string& name, bool infinite = false);

        void stopSound();

        void sayWhoCalls(const std::string& callerDeviceId, const std::string& callerPayload);

    private:
        ipc::SharedMessage createStatusMessageNoLock() const;

        bool endedWithErrorNoLock() const;

        bool callAcceptedNoLock() const;

        void heartbeat();

    private:
        using CallError = std::pair<messenger::CallTransport::ErrorCode, std::string>;

    private:
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        Signal<IStatusChangedSignal> statusChangedSignal_;

        messenger::SessionProvider sessionProvider_;
        std::shared_ptr<messenger::Session> session_;

        messenger::Session::StateChangedSubscription sessionStateSubscription_;
        messenger::Session::CallAcceptedSubscription callAcceptedSubscription_;
        messenger::Session::CallDeclinedSubscription callDeclinedSubscription_;
        messenger::Session::CallFailedSubscription callFailedSubscription_;
        messenger::CallbackSubscription callCreationFailedSubscription_;

        std::atomic_bool mediaPlaying_{false};
        std::atomic_bool shouldResumeMedia_{false};

        mutable std::mutex lock_;
        std::optional<messenger::Session::State> state_;
        std::optional<CallError> lastError_;
        bool declined_{false};
        bool connectedOnce_{false};
        std::string currentSound_;

        const std::shared_ptr<YandexIO::DeviceContext> deviceContext_;

        NamedCallbackQueue worker_{"CallEndpoint"};

        std::shared_ptr<YandexIO::SDKInterface> sdk_;
    };

} // namespace quasar
