#pragma once

#include "call_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace YandexIO {
    class Device;
} // namespace YandexIO

namespace messenger {
    class Session;
} // namespace messenger

namespace quasar {

    class CallService: public QuasarService {
    public:
        static const std::string SERVICE_NAME;

        CallService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<YandexIO::SDKInterface> sdk);

        ~CallService();

        std::string getServiceName() const override;

        void start() override;

    private:
        void run();

        bool getNonSelfCallsAllowedNoLock() const;
        ipc::SharedMessage getCallStatusUnsafe();

    private:
        Lifetime lifetime_;
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::shared_ptr<IStereoPairProvider> stereoPairProvider_;

        std::mutex lock_;
        bool enabled_;
        bool stopped_;
        bool restart_;
        bool nonSelfCallsAllowed_;
        bool forceNonSelfCallsAllowed_;
        bool dndMode_;
        std::vector<std::string> xivaSubscriptions_;
        bool hasMessengerXivaSubscription_;
        quasar::SteadyConditionVariable cv_;

        std::vector<std::string> autoAcceptUsers_;

        std::shared_ptr<ipc::IConnector> toSyncd_;
        std::shared_ptr<ipc::IConnector> toPushd_;
        std::shared_ptr<ipc::IConnector> toDoNotDisturb_;
        std::shared_ptr<ipc::IServer> server_;

        std::shared_ptr<CallEndpoint> endpoint_;
        std::atomic<bool> isStereoPairFollower_{false};

        std::shared_ptr<const AuthInfo2> authInfo_;
        std::shared_ptr<YandexIO::SDKInterface> sdk_;

        std::thread worker_;
    };

} // namespace quasar
