#pragma once

#include "time_info.h"

#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/private/device_context.h>

#include <optional>

namespace quasar {

    class DoNotDisturbEndpoint {
    public:
        explicit DoNotDisturbEndpoint(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~DoNotDisturbEndpoint();
        constexpr static const char* SERVICE_NAME = "do_not_disturb";
        constexpr static const char* DND_START_TIME_DEFAULT = "23:00";
        constexpr static const char* DND_END_TIME_DEFAULT = "09:00";
        void handleQuasarMessage(const proto::QuasarMessage& message);
        TimeInfo getCurrentTimeInfo() const;
        void handleConfigQuasarMessage(const proto::QuasarMessage& message);
        void handleTimezone(const proto::Timezone& timezone);
        void planPendingDndStatus();
        void updateDndStatus();
        void checkUpdateIfNeed(std::optional<TimeInfo>& startTime, std::optional<TimeInfo>& endTime,
                               bool useDefaultDndTime);
        TimeInfo getNextChangeDndTime(const TimeInfo& startTime, const TimeInfo& endTime) const;
        void setDoNotDisturbTime(const TimeInfo& startTime, const TimeInfo& endTime);

    private:
        static bool parseUserDndModeConfig(const Json::Value& dndModeConfig, std::optional<TimeInfo>& startTime,
                                           std::optional<TimeInfo>& endTime);
        static bool parseQuasmodromDndConfig(const Json::Value& dndPrefsConfig, std::optional<TimeInfo>& startTime,
                                             std::optional<TimeInfo>& endTime);

        static const int TIME_STR_LENGTH = 5;
        static proto::QuasarMessage createDndMessage(bool is_dnd_enabled);
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IServer> server_;
        std::mutex mutex_;

        std::optional<TimeInfo> startDoNotDisturbTime_ = TimeInfo::parse(DND_START_TIME_DEFAULT);
        std::optional<TimeInfo> endDoNotDisturbTime_ = TimeInfo::parse(DND_END_TIME_DEFAULT);
        std::shared_ptr<ipc::IConnector> syncdConnector_;
        std::shared_ptr<ipc::IConnector> ntpdConnector_;
        std::unique_ptr<YandexIO::DeviceContext> deviceContext_;
        void sendDndTimesUpdateEvent(const std::string& oldStartTime, const std::string& oldEndTime,
                                     const std::string& newStartTime, const std::string& newEndTime);

        bool doNotDisturb_ = false;
        bool useDefaultDndTime_ = true;
        bool isSyncTimeSuccessful_ = false;
        bool isTimezoneDetected_ = false;
        int timezoneOffsetSec_ = 0;

        NamedCallbackQueue dndStatusUpdateQueue_{"DoNotDisturbEndpoint"};
        Lifetime dndStatusUpdateLifetime_;
    };
} // namespace quasar
