#include "do_not_disturb_service.h"

using namespace quasar;

DoNotDisturbService::DoNotDisturbService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
{
}

std::string quasar::DoNotDisturbService::getServiceName() const {
    return DoNotDisturbEndpoint::SERVICE_NAME;
}

void DoNotDisturbService::start() {
    doNotDisturbEndpoint_ = std::make_unique<DoNotDisturbEndpoint>(device_, ipcFactory_);
}
