#pragma once

#include "do_not_disturb_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class DoNotDisturbService: public QuasarService {
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<DoNotDisturbEndpoint> doNotDisturbEndpoint_;

    public:
        explicit DoNotDisturbService(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        [[nodiscard]] std::string getServiceName() const override;

    private:
        void start() override;
    };
} // namespace quasar
