#pragma once

#include <iostream>
#include <optional>

namespace quasar {
    class TimeInfo {
    public:
        TimeInfo();
        TimeInfo(int hours, int minutes, int seconds, bool hasTimezone = false, int timezoneOffsetSec = 0);

        static std::optional<TimeInfo> parse(const std::string& timeStr);

        int calculateNextTimeDeltaSeconds(const TimeInfo& other) const;
        bool insideInterval(const TimeInfo& leftBorder, const TimeInfo& rightBorder) const;

        bool operator<(const TimeInfo& other) const;
        bool operator>(const TimeInfo& other) const;
        bool operator>=(const TimeInfo& other) const;
        bool operator==(const TimeInfo& other) const;
        bool operator!=(const TimeInfo& other) const;
        std::string to_string() const;
        int getDeltaSeconds(const TimeInfo& other) const;
        int getTotalSeconds() const;

        int hours_;
        int minutes_;
        int seconds_;
        bool hasTimezone_ = false;
        int timezoneOffsetSec_ = 0;

    private:
        static const int PER_DAY_SECONDS = 60 * 60 * 24;
    };
} // namespace quasar

std::ostream& operator<<(std::ostream& os, const quasar::TimeInfo& timeInfo);
std::istream& operator>>(std::istream& is, quasar::TimeInfo& timeInfo);
