#pragma once

#include <yandex_io/external_libs/datacratic/soa/service/http_endpoint.h>
#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/device_state/i_device_state_provider.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <memory>
#include <mutex>
#include <string>

namespace quasar {

    namespace check_token {

        class Exception: public std::runtime_error {
        public:
            explicit Exception(const std::string& message)
                : std::runtime_error(message)
            {
            }

            virtual ~Exception() = default;
        };

        class Non200ResponseCodeException: public Exception {
        public:
            explicit Non200ResponseCodeException(int code)
                : Exception("Non-200 response code:" + std::to_string(code))
                , code_(code)
            {
            }

            virtual ~Non200ResponseCodeException() = default;

            int getResponseCode() const {
                return code_;
            }

        private:
            int code_;
        };
    } // namespace check_token

    class CheckToken {
    public:
        explicit CheckToken(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
            std::chrono::milliseconds timeout = std::chrono::milliseconds(3000));
        ~CheckToken();

        CheckToken(const CheckToken&) = delete;
        CheckToken(CheckToken&&) = delete;
        CheckToken& operator=(const CheckToken&) = delete;
        CheckToken& operator=(CheckToken&&) = delete;

        bool check(const std::string& token);

    private:
        static Json::Value checkAndParseResponse(const HttpClient::HttpResponse& response);
        quasar::HttpClient::Headers getHeaders();

    private:
        Lifetime lifetime_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        const std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        const std::string backendUrl_;

        std::shared_ptr<const AuthInfo2> authInfo_;
        std::shared_ptr<const DeviceState> deviceState_;
        HttpClient backendClient_;
        SteadyConditionVariable condVar_;
        std::mutex mutex_;
    };
} // namespace quasar
