#include "first_run_service.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/telemetry/telemetry.h>

#include <memory>

using namespace quasar;

FirstRunService::FirstRunService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
    std::shared_ptr<IUpdatesProvider> updatesProvider,
    std::shared_ptr<IUserConfigProvider> userConfigProvider,
    std::shared_ptr<YandexIO::SDKInterface> sdk)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , deviceStateProvider_(std::move(deviceStateProvider))
    , updatesProvider_(std::move(updatesProvider))
    , userConfigProvider_(std::move(userConfigProvider))
    , sdk_(std::move(sdk))
{
}

std::string FirstRunService::getServiceName() const {
    return FirstRunEndpoint::SERVICE_NAME;
}

void FirstRunService::start() {
    srand(time(nullptr));
    auto config = device_->configuration()->getServiceConfig("firstrund");

    YIO_LOG_INFO("Starting service firstrund version " << device_->softwareVersion());
    YIO_LOG_INFO("Device id: " << device_->deviceId());
    YIO_LOG_INFO("HttpPort: " << getInt(config, "httpPort"));

    endpointPtr_ = std::make_unique<FirstRunEndpoint>(device_, ipcFactory_, authProvider_,
                                                      deviceStateProvider_, updatesProvider_, userConfigProvider_,
                                                      sdk_->getFilePlayerCapability());
    endpointPtr_->start();
}

void FirstRunService::sync() {
    endpointPtr_->waitConnectorsConnections();
}
