#pragma once

#include "first_run_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace quasar {
    class FirstRunService: public QuasarService {
    public:
        FirstRunService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IDeviceStateProvider> deviceStateProvider,
            std::shared_ptr<IUpdatesProvider> updatesProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider,
            std::shared_ptr<YandexIO::SDKInterface> sdk);

        std::string getServiceName() const override;

        /**
         * @brief wait until FirstrunEndpoint ipc established connections
         * @note: should be called after start
         */
        void sync() override;

    private:
        void start() override;

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<IAuthProvider> authProvider_;
        std::shared_ptr<IDeviceStateProvider> deviceStateProvider_;
        std::shared_ptr<IUpdatesProvider> updatesProvider_;
        std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        const std::shared_ptr<YandexIO::SDKInterface> sdk_;
        std::unique_ptr<FirstRunEndpoint> endpointPtr_;
    };

} // namespace quasar
