#pragma once

#include <string>
#include <unordered_map>

using flb_ctx_t = struct flb_lib_ctx;

namespace quasar {

    class FluentBitCtx {
    public:
        FluentBitCtx();
        ~FluentBitCtx();

        void addInput(const std::string& name, const std::unordered_multimap<std::string, std::string>& properties);
        void addFilter(const std::string& name, const std::unordered_multimap<std::string, std::string>& properties);
        void addOutput(const std::string& name, const std::unordered_multimap<std::string, std::string>& properties);

        void setProperties(const std::unordered_multimap<std::string, std::string>& properties);

        void start();

        void log(const std::string& data);

        int loadLogcatPlugin();
        void initInternalLogging(const std::string& logPath);

    private:
        flb_ctx_t* ctx_;
        int libInput_;
    };

} // namespace quasar
