#pragma once

#include <yandex_io/services/fluent-bitd/fluent_bit_base.h>

#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {

    constexpr const char* DEFAULT_LOG_PATH = "fluent-log.txt";

    class FluentBitCtx;

    class FluentBitLib: public FluentBitBase {
    public:
        FluentBitLib(std::shared_ptr<YandexIO::IDevice> device, const Json::Value& config, const std::shared_ptr<ipc::IIpcFactory>& ipcFactory);
        ~FluentBitLib();

    protected:
        void setupFluentBit() override;

    private:
        void processQuasarMessage(const proto::QuasarMessage& message);

    private:
        std::vector<std::string> tailPaths_;

        std::mutex mutex_;
        std::unique_ptr<FluentBitCtx> flb_;

        std::shared_ptr<ipc::IServer> server_;

        bool internalLogEnabled_ = false;
        std::string internalLogPath_;

        bool libLogsEnabled_ = true;
    };

} // namespace quasar
