#pragma once

#include "i_fluent_bit.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/configuration/configuration_helper.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/threading/periodic_executor.h>

namespace quasar {

    class FluentBitBase: public IFluentBit {
    public:
        explicit FluentBitBase(std::shared_ptr<YandexIO::IDevice> device, const Json::Value& config);
        ~FluentBitBase();

        void init() override;
        void teardown() override;
        void processNewConfig(const Json::Value& config) override;

    private:
        void makeTailDbBackup();
        void loadTailDbBackup();

        void collectMetrics();
        Json::Value makeRequest(std::string_view tag, const std::string& endpoint, const std::string& path);

    protected:
        virtual void setupFluentBit() = 0;

        virtual void reportMetrics(const std::string& name, const Json::Value& value);

    protected:
        std::shared_ptr<YandexIO::IDevice> device_;

        bool enabled_;
        std::map<std::string, std::string> variables_;

    private:
        ConfigurationHelper configHelper_;
        std::mutex configMutex_;

        const std::string tailDbBackupFileName_;

        HttpClient httpClient_;
        std::unique_ptr<quasar::PeriodicExecutor> collectMetricsExecutor_;
    };

} // namespace quasar
