#pragma once

#include "fluent_bit_base.h"

namespace quasar {

    class FluentBitClient: public FluentBitBase {
    public:
        explicit FluentBitClient(std::shared_ptr<YandexIO::IDevice> device, const Json::Value& config);
        ~FluentBitClient();

    protected:
        void setupFluentBit() override;

    private:
        void writeDeviceConfig();
        void writeVariablesConfig();
        void updateConfigSymlink();
        void restartFluentBit();

    private:
        const std::string deviceCfgFileName_;
        const std::string variablesCfgFileName_;
        const std::string setModeScriptFileName_;
        const std::string killScriptFileName_;
    };

} // namespace quasar
