#include "fluent_bit_service.h"

#include <yandex_io/libs/base/persistent_file.h>
#include <yandex_io/libs/configuration/configuration_helper.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <cstdio>
#include <cstdlib>
#include <fstream>

using namespace quasar;
const std::string FluentBitService::SERVICE_NAME = "fluent-bitd";

FluentBitService::FluentBitService(std::shared_ptr<YandexIO::IDevice> device, const std::shared_ptr<ipc::IIpcFactory>& ipcFactory, std::unique_ptr<IFluentBit> client)
    : device_(std::move(device))
    , syncdConnector_(ipcFactory->createIpcConnector("syncd"))
    , client_(std::move(client))
{
    syncdConnector_->setMessageHandler([this](const auto& message) { onQuasarMessage(*message); });
}

std::string FluentBitService::getServiceName() const {
    return FluentBitService::SERVICE_NAME;
}

void FluentBitService::start() {
    client_->init();

    syncdConnector_->connectToService();
}

void FluentBitService::stop() {
    client_->teardown();
}

void FluentBitService::onQuasarMessage(const quasar::proto::QuasarMessage& message) {
    if (!message.has_user_config_update()) {
        return;
    }

    auto systemConfig = parseJson(message.user_config_update().config())["system_config"];
    client_->processNewConfig(systemConfig["fluent-bit"]);
}
