#pragma once

#include "i_fluent_bit.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <string>

namespace quasar {

    class FluentBitService: public QuasarService {
    public:
        static const std::string SERVICE_NAME;

        FluentBitService(std::shared_ptr<YandexIO::IDevice> device, const std::shared_ptr<ipc::IIpcFactory>& ipcFactory, std::unique_ptr<IFluentBit> client);

        std::string getServiceName() const override;
        void start() override;
        void stop() override;

    private:
        void onQuasarMessage(const quasar::proto::QuasarMessage& message);

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IConnector> syncdConnector_;

    protected:
        std::unique_ptr<IFluentBit> client_;
    };

} // namespace quasar
