#pragma once

#include <fluent-bit/flb_info.h>
#include <fluent-bit/flb_input.h>
#include "logprint.h"

#define DEFAULT_SOCKET_PATH "/dev/socket/logdr"
#define DEFAULT_CONTROL_SOCKET_PATH "/dev/socket/logd"
#define DEFAULT_LOG_BUFFER_SIZE "1048576" /* 1 MB */

const int MAX_COMMAND_RESPONSE_LEN = 32;
const int MAX_COMMAND_LEN = 64;

const int MIN_DELAY_SEC = 1;
const int MAX_DELAY_SEC = 32;
const int DELAY_AMPLIFY = 2;

struct flb_logcat {
    struct flb_input_instance* ins;
    int server_fd;
    char* path;
    char* socket_path;
    char* control_socket_path;
    int log_buffer_size;
    int collector_id;
};

#define report_error(ctx, fmt, ...)                \
    flb_plg_error((ctx)->ins, fmt, ##__VA_ARGS__); \
    output_error_as_log((ctx), fmt, ##__VA_ARGS__)

extern int output_error_as_log(struct flb_logcat* ctx, const char* fmt, ...);

typedef enum control_command_result {
    SUCCESS = 0,
    PERMISSION_DENIED = 1,
    INTERNAL_ERROR = 2
} control_command_result;

extern struct flb_input_plugin in_logcat_plugin;
