#pragma once

#include "entities.h"

#include <fluent-bit/flb_input_plugin.h>

#include <stdint.h>
#include <time.h>

#define MS_PER_NSEC 1000000
#define NS_PER_SEC 1000000000ULL

typedef struct AndroidLogEntry {
    time_t tv_sec;
    long tv_nsec;
    android_LogPriority priority;
    int32_t uid;
    int32_t pid;
    int32_t tid;
    const char* tag;
    size_t tagLen;
    size_t messageLen;
    const char* message;
} AndroidLogEntry;

int parseLogEntry(log_msg* buf, int length, AndroidLogEntry* entry, struct flb_input_instance* ins);
char* formatLogLine(char* defaultBuffer,
                    size_t defaultBufferSize, const AndroidLogEntry* entry,
                    size_t* p_outLength);
