#pragma once

#include <chrono>
#include <cstdint>
#include <optional>

namespace glagol {
    struct AvahiSettings {
        bool restrictToIPv4{true};
        bool queuingResolves{false};
        std::uint64_t ratelimitIntervalUsec{0};
        unsigned ratelimitBurst{0};
        std::chrono::seconds recreateBrowserInterval{0}; // 0 - do not recreate

        struct Flags {
            bool guestMode{false};
            std::optional<bool> stereopair; // not anounced when optional is empty
            std::optional<bool> tandem;
        } flags;
    };

    std::string toString(const AvahiSettings::Flags& /*flags*/);
} // namespace glagol
