#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/glagol_sdk/i_backend_api.h>
#include <yandex_io/libs/http_client/i_simple_http_client.h>

#include <json/json.h>

#include <string>
#include <memory>

namespace glagol {
    class BackendDeviceStateUpdater {
    public:
        virtual void updateNetworkInfoField(IBackendApi::NetworkInfo info) = 0;
        virtual void setMinimalSendingInterval(std::chrono::seconds interval) = 0; // 0 will reset to default
        virtual ~BackendDeviceStateUpdater() = default;
    };

    std::unique_ptr<BackendDeviceStateUpdater> makeBackendDeviceStateUpdater(std::shared_ptr<YandexIO::IDevice> device, std::shared_ptr<quasar::IAuthProvider> authProvider, std::shared_ptr<quasar::ISimpleHttpClient> backendClient);
} // namespace glagol
