#include "bypass_directive_handler.h"

#include <yandex_io/libs/glagol_sdk/defs.h>
#include <yandex_io/libs/logging/logging.h>

using namespace glagol;
using namespace YandexIO;

namespace {

    Json::Value convertDirectiveToBypass(const std::shared_ptr<Directive> directive, const std::string& deviceId) {
        constexpr const char* COMMAND_NAME = "externalCommandBypass";
        const auto commandMsg = YandexIO::Directive::convertToExternalCommandProtobuf(directive);
        const auto msgString = commandMsg.SerializeAsString();
        Json::Value result;
        result["command"] = COMMAND_NAME;
        result["data"] = quasar::base64Encode(msgString.c_str(), msgString.size());
        result["from_device_id"] = deviceId;
        return result;
    }

    Json::Value convertAliceStateToBypass(const std::shared_ptr<Directive> directive, const std::string& deviceId) {
        constexpr const char* COMMAND_NAME = "aliceStateBypass";
        Json::Value result;
        result["command"] = COMMAND_NAME;
        result["data"] = directive->getData().payload["data"];
        result["from_device_id"] = deviceId;
        return result;
    }

} // namespace

BypassDirectiveHandler::BypassDirectiveHandler(std::string endpointId, std::string deviceId, std::shared_ptr<glagol::ext::Connector> connector, std::shared_ptr<quasar::ICallbackQueue> cbQueue)
    : endpointId_(std::move(endpointId))
    , deviceId_(std::move(deviceId))
    , connector_(std::move(connector))
    , cbQueue_(std::move(cbQueue))
{
}

const std::string& BypassDirectiveHandler::getEndpointId() const {
    return endpointId_;
}

const std::string& BypassDirectiveHandler::getHandlerName() const {
    return endpointId_;
}

const std::set<std::string>& BypassDirectiveHandler::getSupportedDirectiveNames() const {
    static const std::set<std::string> SUPPORTED_DIRECTIVES_NAME = {}; // wildcard
    return SUPPORTED_DIRECTIVES_NAME;
}

void BypassDirectiveHandler::handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) {
    cbQueue_->add([this, directive]() {
        if (directive->is("alice_state_bypass")) {
            YIO_LOG_INFO("Sending animate alice state to " << endpointId_);
            connector_->send(glagol::model::RequestPayloadFactory::getShowAliceVisualStatePayload(glagol::LISTENS));
            connector_->send(convertAliceStateToBypass(directive, deviceId_));
        } else {
            YIO_LOG_INFO("Forwarding directive " << directive->getData().name << "to " << endpointId_);
            connector_->send(convertDirectiveToBypass(directive, deviceId_));
        }
    });
}

void BypassDirectiveHandler::cancelDirective(const std::shared_ptr<YandexIO::Directive>& /*directive*/) {
    // ¯\_(ツ)_/¯
}

void BypassDirectiveHandler::prefetchDirective(const std::shared_ptr<YandexIO::Directive>& /*directive*/) {
    // ¯\_(ツ)_/¯
}
