#pragma once

#include <yandex_io/sdk/interfaces/i_directive_handler.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/libs/glagol_sdk/connector2.h>

#include <functional>

namespace glagol {
    class BypassDirectiveHandler: public YandexIO::IDirectiveHandler {
    public:
        BypassDirectiveHandler(std::string endpointId, std::string deviceId, std::shared_ptr<glagol::ext::Connector> connector, std::shared_ptr<quasar::ICallbackQueue> cbQueue);

        const std::string& getEndpointId() const override;
        const std::string& getHandlerName() const override;
        const std::set<std::string>& getSupportedDirectiveNames() const override;

        void handleDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void cancelDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;
        void prefetchDirective(const std::shared_ptr<YandexIO::Directive>& directive) override;

    private:
        const std::string endpointId_;
        const std::string deviceId_;
        const std::shared_ptr<glagol::ext::Connector> connector_;
        const std::shared_ptr<quasar::ICallbackQueue> cbQueue_;
    };
} // namespace glagol
