#pragma once

#include "discovered_items.h"

#include <yandex_io/libs/glagol_sdk/device_id.h>

#include <functional>
#include <list>

namespace glagol {

    class ConnectingQueue {
        using ConnectorPtr = IDiscoveredItems::ConnectorPtr;
        struct ConnectionData {
            DeviceId deviceId;
            DiscoveredItemPtr discoveredItem;
            ConnectorPtr connector;
            std::chrono::steady_clock::time_point started;
            bool timeouted{false};

            ConnectionData(DeviceId id, DiscoveredItemPtr item);
        };

        using ConnectionsList = std::list<ConnectionData>;

    public:
        using ConnectorsFactory = IDiscoveredItems::ConnectorsFactory;
        using OnConnected = std::function<void(const DeviceId&, ConnectorPtr)>;

        ConnectingQueue(unsigned poolSize,
                        ConnectorsFactory connectorsFactory,
                        OnConnected onConnected);

        void queueConnection(const DeviceId& id, DiscoveredItemPtr item);

        void checkTimeouted(std::chrono::seconds interval);

        void setPoolSize(unsigned size);

    private:
        void checkTimeoutedImpl(std::chrono::seconds interval);
        void scheduleConnect();

        void connected(ConnectionsList::iterator iter);

        std::mutex mutex_;
        unsigned poolSize_;
        ConnectorsFactory connectorsFactory_;
        OnConnected onConnected_;

        ConnectionsList waitingQueue_;
        ConnectionsList connectingQueue_;
    };

} // namespace glagol
