#pragma once

#include "resolve_handler.h"
#include "resolve_info.h"

#include <yandex_io/libs/glagol_sdk/connector2.h>
#include <yandex_io/libs/glagol_sdk/i_backend_api.h>
#include <yandex_io/libs/glagol_sdk/i_discovery.h>

#include <functional>

namespace glagol {

    bool isLocalIPAddress(const std::string& address);

    class IDiscoveredItems: public quasar::ResolveHandler {
    public:
        class Storage {
        public:
            virtual void save(const std::string&) = 0;
            virtual std::string getContent() = 0;
            virtual ~Storage() = default;
        };

        using StoragePtr = std::shared_ptr<Storage>;

        struct Settings {
            std::chrono::seconds connectingTimeout = std::chrono::seconds(10);
            std::chrono::seconds outdatingPeriod = std::chrono::minutes(15);
            std::chrono::seconds saveInterval = std::chrono::minutes(15);
            unsigned connectingPoolSize = 5;
            bool disableBackendDiscovery = false;
        };

        using ConnectorPtr = std::shared_ptr<glagol::ext::Connector>;
        using ConnectorsFactory = std::function<IDiscoveredItems::ConnectorPtr()>;
        using OnDiscoveryCallback = std::function<void(const DeviceId&, ConnectorPtr)>;
        using ResolvedItemCallback = std::function<void(const glagol::ResolveItem&, const glagol::ResolveItem::Info&)>;

        struct NearbyDevice {
            bool isAccountDevice;
            std::string address;
        };

        using DevicesArround = std::map<DeviceId, NearbyDevice>;

        void removeResolve(const ResolveItem& /*item*/) override = 0;
        virtual void removeResolve(const ResolveItem& item, ResolveItem::SourceFlag sourceFlag) = 0;

        virtual void addResolve(const DeviceId& deviceId, ResolveInfo resolveInfo, ResolveSource resolveSource) = 0;

        virtual void updateAccountDevices(const glagol::IBackendApi::DevicesMap& deviceIds) = 0;

        virtual void eachResolvedItem(ResolvedItemCallback callback) const = 0;
        virtual IDiscovery::Result getDiscoveries() const = 0;

        virtual DevicesArround getDevicesAround() const = 0;
        virtual bool noDevicesAround() const = 0;
        virtual void setOnDiscoveryCallback(OnDiscoveryCallback callback) = 0;
        virtual void setOnNeighborsUpdated(std::function<void()> callback) = 0;

        virtual void periodicCheck() = 0;
        virtual void setSettings(const Settings& settings) = 0;

        virtual ~IDiscoveredItems() = default;
    };

    std::shared_ptr<IDiscoveredItems> createDiscoveredItems(DeviceId self,
                                                            std::shared_ptr<YandexIO::ITelemetry> telemetry,
                                                            std::shared_ptr<IBackendApi> /*backendApi*/,
                                                            IDiscoveredItems::StoragePtr /*storage*/,
                                                            IDiscoveredItems::ConnectorsFactory /*connectorsFactory*/);
} // namespace glagol
