#pragma once

#include "avahi_settings.h"
#include "resolve_handler.h"
#include "responder_status.h"

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/mdns/nsd_messager.h>

#include <memory>
#include <variant>

namespace quasar {

    class MDNSHolder {
    public:
        virtual std::shared_ptr<ResponderStatus> getResponderStatusProvider() = 0;
        virtual void setNetworkAvailability(bool) = 0;
        virtual void reconfigure() = 0;
        virtual ~MDNSHolder() = default;
    };

    using MDNSHolderPtr = std::shared_ptr<MDNSHolder>;

    struct MdnsSettings {
        glagol::AvahiSettings::Flags flags;
        uint32_t port;
        std::string prefix;
    };

    struct NsdSettings {};

    using MDNSTransportOpt = std::variant<glagol::AvahiSettings, NsdSettings>;

    using MDNSHolderFactory = std::function<MDNSHolderPtr(std::shared_ptr<YandexIO::IDevice>, const MdnsSettings&, ResolveHandler*, MDNSTransportOpt)>;

    MDNSHolderFactory createDefaultMndsFactory(INsdMessagerFactory& /*nsdMessagerFactory*/);

} // namespace quasar
