#pragma once

#include <yandex_io/libs/mdns/nsd_messager.h>
#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <condition_variable>
#include <memory>
#include <mutex>

namespace quasar {
    class ResolveHadler;
    namespace ipc {
        class IConnector;
        class IIpcFactory;
    } // namespace ipc

    class MdnsdNsdMessager: public INsdMessager {
    public:
        MdnsdNsdMessager(INsdReceiverPtr receiver, std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~MdnsdNsdMessager();

        void enableNsd(bool guestMode, uint32_t port, OptBool stereopair, OptBool tandem) override;

        void disableNsd() override;

    private:
        std::shared_ptr<ipc::IConnector> mdnsdConnector_;
        INsdReceiverPtr receiver_;
        std::atomic_bool nsdDisabling_{false};
        bool nsdDisabled_{false};
        std::mutex data_mutex_;
        std::mutex disable_completed_mutex_;
        std::condition_variable cond_;
        Lifetime lifetime_;
        bool guestMode_{false};
        uint32_t port_{0};
        quasar::proto::GlagolDiscoveryItem_GroupRole stereopair_;
        quasar::proto::GlagolDiscoveryItem_GroupRole tandem_;
    };

    class MdnsdMessagerFactory: public INsdMessagerFactory {
    public:
        MdnsdMessagerFactory(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        INsdMessagerPtr createMessager(INsdReceiverPtr receiver) override;

    private:
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
    };
} // namespace quasar
