#pragma once

#include <memory>
#include <string>
#include <vector>

namespace glagol {
    class NetDevicesMonitor {
    public:
        enum class Family {
            IPV4,
            IPV6
        };
        struct Address {
            Family family;
            std::string addr;
        };
        struct NetDevice {
            std::string interfaceName;
            std::string MAC;
            bool running{false};
            bool loopback{false};
            std::vector<Address> addresses;
        };
        using OnDeviceCallback = std::function<void(const NetDevice&)>;

        virtual void eachRunningDevice(OnDeviceCallback) const = 0;
        virtual void stop() = 0;
        virtual ~NetDevicesMonitor() = default;
    };

    using NetDevicesMonitorPtr = std::unique_ptr<NetDevicesMonitor>;

    NetDevicesMonitorPtr makeNetDevicesMonitor(NetDevicesMonitor::OnDeviceCallback onDeviceUpdated);
} // namespace glagol
