#include "outdate_wrapper.h"

#include <stdexcept>

using namespace glagol;

OutdateWrapper::Info::Info(const ResolveItem::Info& d)
    : details(d)
          {};

bool OutdateWrapper::Info::updateIfDiffer(const ResolveItem::Info& d) {
    outdated = false;
    if (d != details) {
        details = d;
        return true;
    }
    return false;
}

OutdateWrapper::OutdateWrapper(quasar::ResolveHandler* handler)
    : handler_(handler)
{
}

void OutdateWrapper::newResolve(const ResolveItem& item, const ResolveItem::Info& details) {
    auto [iter, inserted] = resolves_.emplace(item, details);
    if (inserted || iter->second.updateIfDiffer(details)) {
        handler_->newResolve(item, details);
    }
}

void OutdateWrapper::removeResolve(const ResolveItem& item) {
    if (resolves_.erase(item)) {
        handler_->removeResolve(item);
    }
}

void OutdateWrapper::refreshStart() {
    for (auto& [item, info] : resolves_) {
        info.outdated = true;
    }
}

void OutdateWrapper::refresh() {
    auto it = std::begin(resolves_);
    while (it != std::end(resolves_)) {
        if (it->second.outdated) {
            handler_->removeResolve(it->first);
            it = resolves_.erase(it);
        } else {
            ++it;
        }
    }
}
