#pragma once

#include "resolve_handler.h"

#include <unordered_map>

namespace glagol {

    /*! This class tracks outdates caused by recreating browser inside MdnsHolder */
    class OutdateWrapper {
        quasar::ResolveHandler* handler_;

        struct Info {
            ResolveItem::Info details;
            bool outdated{false};
            Info(const ResolveItem::Info& /*d*/);

            bool updateIfDiffer(const ResolveItem::Info& /*d*/);
        };

        std::unordered_map<ResolveItem, Info, ResolveItem::Hasher> resolves_;

    public:
        OutdateWrapper(quasar::ResolveHandler* handler);
        void newResolve(const ResolveItem& /*item*/, const ResolveItem::Info& /*details*/);
        void removeResolve(const ResolveItem& /*item*/);
        void refreshStart();
        void refresh();
    };
} // namespace glagol
