#include "proto_utils.h"

using namespace quasar;

using namespace glagol;

ResolveItem glagol::convertResolveItem(const proto::NsdInfo& src) {
    glagol::ResolveItem result;
    result.type = src.type();
    result.name = src.name();
    result.domain = "local"; // FIXME: seems android provides only local resolves
    return result;
}

std::tuple<ResolveItem, ResolveItem::Info> glagol::convertResolveItemFull(const proto::NsdInfo& src) {
    ResolveItem item = convertResolveItem(src);
    ResolveItem::Info info;
    info.hostname = info.address = src.address();
    info.port = src.port();
    for (const auto& attr : src.attrs()) {
        info.txt.emplace(attr.name(), attr.value());
    }
    return {item, info};
}
