#pragma once

#include <yandex_io/libs/glagol_sdk/discovered_item.h>
#include <yandex_io/libs/glagol_sdk/i_discovery.h>

#include <string>

namespace glagol {

    struct ResolveInfo {
        std::string address;
        using Protocol = glagol::DiscoveredItem::Protocol;
        Protocol protocol;
        int port{0};
        bool cluster{false};
        GroupRole tandemRole{RoleNest::STAND_ALONE};
        GroupRole stereopairRole{RoleNest::STAND_ALONE};

        static Protocol protoByAddress(const std::string& addr) {
            return (addr.find(':') == std::string::npos ? Protocol::IPV4 : Protocol::IPV6);
        }

        std::string uri() const {
            if (protocol == Protocol::IPV6) {
                return "[" + address + "]:" + std::to_string(port);
            }
            return address + ":" + std::to_string(port);
        }
    };

    enum class ResolveSource {
        MDNS,
        PEERS,
        BACKEND,
        CONNINFO
    };

} // namespace glagol
