#pragma once

#include "resolve_info.h"

#include <json/json.h>

#include <list>
#include <string>
#include <unordered_map>

namespace glagol {

    class ResolvesTracker {
        using TimePoint = std::chrono::steady_clock::time_point;

        struct ResolveExt;
        using ResolvesList = std::list<ResolveExt>;
        using UriMap = std::unordered_map<std::string, ResolvesList::iterator>;

        struct ResolveExt {
            ResolveInfo info;

            unsigned sourceFlags{0};
            UriMap::iterator uriIter;

            TimePoint lastConnected{std::chrono::seconds(0)};
            TimePoint updated;
        };

        bool hasCluster_{false};
        int clusterCount_{0};
        ResolvesList resolves_;
        UriMap uriToResolve_;
        bool firstLocked_{false};
        GroupRole stereopairRole_{RoleNest::STAND_ALONE};
        GroupRole tandemRole_{RoleNest::STAND_ALONE};

    public:
        bool removeOutdates(std::chrono::seconds outdatingPeriod); //! returns true if had resolves before but became empty
        bool hasResolve() const;
        bool hasClusterResolve() const;
        ResolveInfo getLockedResolve();
        ResolveInfo getLastResolve() const;
        Json::Value serialize() const;
        void deserialize(const Json::Value& /*src*/);
        void unlock(bool wasConnected);

        /* return true if this resolve *better* than existing one */
        bool addResolve(ResolveInfo /*resolve*/, ResolveSource /*src*/);

        bool isCluster() const;
        GroupRole tandemRole() const;
        GroupRole stereopairRole() const;
    };

} // namespace glagol
