#include "iot_service.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

using namespace quasar;

IotService::IotService(std::shared_ptr<YandexIO::IDevice> device,
                       std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                       std::shared_ptr<YandexIO::SDKInterface> sdk)
    : device_{std::move(device)}
    , ipcFactory_(std::move(ipcFactory))
    , discoveryProvider_{device_->hal()->createIotDiscoveryProvider()}
    , sdk_(std::move(sdk))
{
}

std::string IotService::getServiceName() const {
    return IotEndpoint::SERVICE_NAME;
}

void IotService::start() {
    if (discoveryProvider_) {
        endpoint_ = std::make_unique<IotEndpoint>(device_, ipcFactory_, discoveryProvider_, sdk_->getFilePlayerCapability());
        endpoint_->start();
    } else {
        YIO_LOG_INFO("IoT discovery is not available");
    }
}
