#pragma once

#include "iot_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/iot/i_iot_discovery_provider.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace quasar {

    class IotService: public QuasarService {
        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::shared_ptr<YandexIO::IIotDiscoveryProvider> discoveryProvider_;
        std::shared_ptr<YandexIO::SDKInterface> sdk_;

        std::unique_ptr<IotEndpoint> endpoint_;

    public:
        IotService(std::shared_ptr<YandexIO::IDevice> device,
                   std::shared_ptr<ipc::IIpcFactory> ipcFactory,
                   std::shared_ptr<YandexIO::SDKInterface> sdk);

        std::string getServiceName() const override;
        void start() override;
    };

} // namespace quasar
