#pragma once

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/protos/quasar_proto.pb.h>

#include <mutex>

namespace quasar {

    class NetworkEndpoint {
    public:
        NetworkEndpoint(std::shared_ptr<ipc::IIpcFactory> ipcFactory);
        ~NetworkEndpoint();

        int port() const;

        /* Should be used in tests to make sure that networkd is connected to wifid */
        void waitUntilConnected();

        static const std::string SERVICE_NAME;

    private:
        void processQuasarMessage(const ipc::SharedMessage& message,
                                  ipc::IServer::IClientConnection& connection);
        void proxyCall(const std::string& originalRequestId,
                       quasar::proto::QuasarMessage&& wifidRequest,
                       ipc::IServer::IClientConnection& connection);
        void handleWifiMessage(const ipc::SharedMessage& message);

        std::shared_ptr<ipc::IServer> server_;
        std::shared_ptr<ipc::IConnector> wifidConnector_;

        std::mutex mutex_;
        proto::NetworkStatus currentNetworkStatus_;
    };

} /* namespace quasar */
