#include "network_service.h"

#include <memory>

using namespace quasar;

NetworkService::NetworkService(std::shared_ptr<ipc::IIpcFactory> ipcFactory)
    : ipcFactory_(std::move(ipcFactory))
{
}

std::string NetworkService::getServiceName() const {
    return NetworkEndpoint::SERVICE_NAME;
}

void NetworkService::start() {
    endpointPtr_ = std::make_unique<NetworkEndpoint>(ipcFactory_);
}
