#pragma once

#include "network_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

namespace quasar {
    class NetworkService: public QuasarService {
    public:
        NetworkService(std::shared_ptr<ipc::IIpcFactory> ipcFactory);

        std::string getServiceName() const override;

        void start() override;

    private:
        std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<NetworkEndpoint> endpointPtr_;
    };
} // namespace quasar
