#pragma once

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>
#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>
#include <yandex_io/sdk/private/device_context.h>

namespace quasar {

    class NotificationEndpoint {
    public:
        explicit NotificationEndpoint(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider,
            std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability);
        ~NotificationEndpoint();
        constexpr static const char* SERVICE_NAME = "notificationd";
        void handleQuasarMessage(const ipc::SharedMessage& message);
        void handleDoNotDisturbMessage(const ipc::SharedMessage& message);
        void handleAccountChange();
        void onConfigChanged(const Json::Value& notificationPrefsConfig);

    private:
        void handleNotifyDirective(const proto::NotifyDirective& notifyDirective);
        void onUpdateNotifications(int count, proto::NotifyDirective_RingType ringType);
        bool shouldPlaySound(const proto::NotifyDirective& notifyDirective) const;
        void playNotificationSound();
        void setDoNotDisturbMode(bool doNotDisturb);
        void updateNotificationMode();
        void sendNotificationUpdateEvent(const proto::NotifyDirective& notifyDirective);
        static std::string getRingTypeStr(proto::NotifyDirective_RingType ringType);
        static bool isNotificationActiveState(proto::NotifyDirective_RingType ringType, int notificationCount, bool doNotDisturb);

        void processNotifyDirective(const proto::NotifyDirective& notifyDirective);
        void updateStereoPairFollower(bool isStereoPairFollower);

        void onNotificationSoundCompleted();

    private:
        static constexpr std::chrono::milliseconds TO_PASSIVE_MODE_MILLISECONDS{5800};
        static constexpr int DEFAULT_VERSION_ID = -1;

        Lifetime lifetime_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        const std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability_;
        std::shared_ptr<YandexIO::DeviceContext> deviceContext_;
        std::shared_ptr<ipc::IServer> server_;
        std::shared_ptr<ipc::IConnector> toDoNotDisturb_;
        bool isStereoPairFollower_{false};
        int64_t versionId_ = DEFAULT_VERSION_ID;
        bool doNotDisturb_ = false;
        int32_t notificationsCount_ = 0;
        bool notificationsEnabled_ = true;
        proto::NotificationUpdateEvent_NotificationMode notificationState_{proto::NotificationUpdateEvent_NotificationMode_NONE};

        static constexpr std::array<const char*, 3> ringTypeMap_{"nosound", "delicate", "proactive"};
        struct Settings;
        std::unique_ptr<Settings> defaultSettings_;

        bool enableSyncVolume_;
        std::chrono::milliseconds syncVolumeTimeout_;
        struct PendingNotification {
            const proto::NotifyDirective notifyDirective;
            const std::chrono::milliseconds requestTimestamp;
            PendingNotification(proto::NotifyDirective directive,
                                std::chrono::milliseconds timestamp)
                : notifyDirective(std::move(directive))
                , requestTimestamp(timestamp)
                      {};
        };
        std::unique_ptr<PendingNotification> pendingNotification_;
        std::shared_ptr<NamedCallbackQueue> asyncQueue_;
        std::set<std::string> notificationBlockers_;

        const std::shared_ptr<YandexIO::IPlaySoundFileListener> playSoundFileListener_;
    };
} // namespace quasar
