#include "notification_service.h"

using namespace quasar;

NotificationService::NotificationService(
    std::shared_ptr<YandexIO::IDevice> device,
    std::shared_ptr<ipc::IIpcFactory> ipcFactory,
    std::shared_ptr<IAuthProvider> authProvider,
    std::shared_ptr<IStereoPairProvider> stereoPairProvider,
    std::shared_ptr<IUserConfigProvider> userConfigProvider,
    std::shared_ptr<YandexIO::SDKInterface> sdk)
    : device_(std::move(device))
    , ipcFactory_(std::move(ipcFactory))
    , authProvider_(std::move(authProvider))
    , stereoPairProvider_(std::move(stereoPairProvider))
    , userConfigProvider_(std::move(userConfigProvider))
    , sdk_(std::move(sdk))
{
}

std::string quasar::NotificationService::getServiceName() const {
    return NotificationEndpoint::SERVICE_NAME;
}

void NotificationService::start() {
    notificationEndpoint_ = std::make_unique<NotificationEndpoint>(device_, ipcFactory_, authProvider_, stereoPairProvider_,
                                                                   userConfigProvider_, sdk_->getFilePlayerCapability());
}
