#pragma once

#include "notification_endpoint.h"

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/interfaces/stereo_pair/i_stereo_pair_provider.h>
#include <yandex_io/interfaces/user_config/i_user_config_provider.h>
#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/sdk/sdk_interface.h>

namespace quasar {
    class NotificationService: public QuasarService {
        const std::shared_ptr<YandexIO::IDevice> device_;
        const std::shared_ptr<ipc::IIpcFactory> ipcFactory_;
        const std::shared_ptr<IAuthProvider> authProvider_;
        const std::shared_ptr<IStereoPairProvider> stereoPairProvider_;
        const std::shared_ptr<IUserConfigProvider> userConfigProvider_;
        const std::shared_ptr<YandexIO::SDKInterface> sdk_;
        std::unique_ptr<NotificationEndpoint> notificationEndpoint_;

    public:
        explicit NotificationService(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<IAuthProvider> authProvider,
            std::shared_ptr<IStereoPairProvider> stereoPairProvider,
            std::shared_ptr<IUserConfigProvider> userConfigProvider,
            std::shared_ptr<YandexIO::SDKInterface> sdk);
        [[nodiscard]] std::string getServiceName() const override;

    private:
        void start() override;
    };
} // namespace quasar
